"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const pasaporte_log_entity_1 = require("../pasaporte_log/entities/pasaporte_log.entity");
const passport_service_1 = require("../passport/passport.service");
const typeorm_2 = require("typeorm");
let SyncService = class SyncService {
    logRepo;
    passportService;
    urls = [
        'https://bromidic-piranha-3420.dataplicity.io/api/passport/count',
        'https://grizzlier-pademelon-6720.dataplicity.io/api/passport/count',
        'https://solstitial-bongo-9311.dataplicity.io/api/passport/count',
        'https://jalapic-ragdoll-7934.dataplicity.io/api/passport/count',
        'https://introvert-rail-9851.dataplicity.io/api/passport/count',
    ];
    constructor(logRepo, passportService) {
        this.logRepo = logRepo;
        this.passportService = passportService;
    }
    async saveLog(data) {
        const logs = data.map((log) => {
            return this.logRepo.create({
                passportScan: log.passportScan,
                status: log.status,
                fecha: log.fecha,
                ts: log.ts,
                numeroLocal: log.numeroLocal,
            });
        });
        await this.logRepo.save(logs);
    }
    async getPasaportesActualizadosDesde(fecha, limit = 50) {
        return this.passportService.find({
            where: { updatedAt: (0, typeorm_2.MoreThan)(fecha) },
            order: { updatedAt: 'ASC' },
            take: limit,
        });
    }
    async getConteosDeTotems() {
        const resultados = await Promise.all(this.urls.map(async (url) => {
            try {
                const res = await fetch(url);
                const data = await res.json();
                if (data.count && data.count.resultado) {
                    return `Count from ${url} : ${data.count.resultado}`;
                }
                return `Count from ${url} : ${JSON.stringify(data)}`;
            }
            catch (e) {
                return `${url} : ERROR`;
            }
        }));
        return resultados;
    }
};
exports.SyncService = SyncService;
exports.SyncService = SyncService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(pasaporte_log_entity_1.PassportLog)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        passport_service_1.PassportService])
], SyncService);
//# sourceMappingURL=sync.service.js.map