"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncController = void 0;
const common_1 = require("@nestjs/common");
const sync_service_1 = require("./sync.service");
let SyncController = class SyncController {
    syncService;
    constructor(syncService) {
        this.syncService = syncService;
    }
    async receiveData(body, authHeader, res) {
        const token = authHeader?.split(' ')[1];
        if (token !== process.env.SYNC_TOKEN) {
            return res
                .status(common_1.HttpStatus.UNAUTHORIZED)
                .json({ message: 'Unauthorized' });
        }
        await this.syncService.saveLog(body);
        return res.status(common_1.HttpStatus.OK).json({ message: 'OK' });
    }
    async getPasaportesActualizados(desde, limitStr, authHeader) {
        if (!authHeader) {
            throw new common_1.UnauthorizedException('No authorization header');
        }
        const token = authHeader.split(' ')[1]?.trim();
        if (token !== process.env.SYNC_TOKEN) {
            console.log('⚠️ Token inválido recibido:', token);
            throw new common_1.UnauthorizedException('Invalid token');
        }
        if (!desde) {
            throw new common_1.BadRequestException('Query param "desde" is required');
        }
        const fecha = new Date(desde);
        const limit = limitStr ? parseInt(limitStr, 10) : 50;
        return this.syncService.getPasaportesActualizadosDesde(fecha, limit);
    }
    async getTotemCounts() {
        return this.syncService.getConteosDeTotems();
    }
};
exports.SyncController = SyncController;
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __param(1, (0, common_1.Headers)('authorization')),
    __param(2, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String, Object]),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "receiveData", null);
__decorate([
    (0, common_1.Get)('pasaportes-actualizados'),
    __param(0, (0, common_1.Query)('desde')),
    __param(1, (0, common_1.Query)('limit')),
    __param(2, (0, common_1.Headers)('Authorization')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, String, String]),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "getPasaportesActualizados", null);
__decorate([
    (0, common_1.Get)('totems/pasaportes-count'),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SyncController.prototype, "getTotemCounts", null);
exports.SyncController = SyncController = __decorate([
    (0, common_1.Controller)('sync'),
    __metadata("design:paramtypes", [sync_service_1.SyncService])
], SyncController);
//# sourceMappingURL=sync.controller.js.map