"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PassportService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const passport_entity_1 = require("./entities/passport.entity");
let PassportService = class PassportService {
    passportRepository;
    constructor(passportRepository) {
        this.passportRepository = passportRepository;
    }
    findUpdatedSince(fecha) {
        return this.passportRepository.find({
            where: {
                updatedAt: (0, typeorm_2.MoreThan)(fecha),
            },
        });
    }
    async find(options) {
        return this.passportRepository.find(options);
    }
    async createUpdateMany(passports) {
        for (const item of passports) {
            const existing = await this.passportRepository.findOne({
                where: { passport: item.passport },
            });
            if (existing) {
                existing.active = item.active;
                existing.name = item.name;
                await this.passportRepository.save(existing);
            }
            else {
                await this.passportRepository.save(this.passportRepository.create(item));
            }
        }
    }
    async updateStatus(id, active) {
        const passport = await this.passportRepository.findOneBy({ id });
        if (!passport) {
            throw new Error(`Passport with id ${id} not found`);
        }
        passport.active = active;
        passport.updatedAt = new Date();
        return this.passportRepository.save(passport);
    }
    findByPassportNumber(passport) {
        return this.passportRepository.findOne({
            where: { passport: passport.trim().toLowerCase() },
        });
    }
    async countPassports() {
        return this.passportRepository.count();
    }
};
exports.PassportService = PassportService;
exports.PassportService = PassportService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(passport_entity_1.Passport)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], PassportService);
//# sourceMappingURL=passport.service.js.map