import { Repository } from 'typeorm';
import { Passport } from './entities/passport.entity';
export declare class PassportService {
    private passportRepository;
    constructor(passportRepository: Repository<Passport>);
    findUpdatedSince(fecha: Date): Promise<Passport[]>;
    find(options?: any): Promise<Passport[]>;
    createUpdateMany(passports: {
        passport: string;
        active: boolean;
        name: string;
    }[]): Promise<void>;
    updateStatus(id: number, active: boolean): Promise<Passport>;
    findByPassportNumber(passport: string): Promise<Passport | null>;
    countPassports(): Promise<number>;
}
