"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PassportController = void 0;
const common_1 = require("@nestjs/common");
const update_passport_dto_1 = require("./dto/update-passport.dto");
const passport_service_1 = require("./passport.service");
let PassportController = class PassportController {
    passportService;
    constructor(passportService) {
        this.passportService = passportService;
    }
    async findUpdatedSince(updatedSince) {
        const date = updatedSince ? new Date(updatedSince) : new Date(0);
        return this.passportService.findUpdatedSince(date);
    }
    async findByPassportNumber(passportNumber) {
        const result = await this.passportService.findByPassportNumber(passportNumber);
        if (!result) {
            throw new common_1.NotFoundException('Pasaporte no encontrado');
        }
        return result;
    }
    updatePassportStatus(id, dto) {
        return this.passportService.updateStatus(id, dto.active);
    }
};
exports.PassportController = PassportController;
__decorate([
    (0, common_1.Get)(),
    __param(0, (0, common_1.Query)('updatedSince')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PassportController.prototype, "findUpdatedSince", null);
__decorate([
    (0, common_1.Get)('by-number/:passportNumber'),
    __param(0, (0, common_1.Param)('passportNumber')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PassportController.prototype, "findByPassportNumber", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_passport_dto_1.UpdatePassportStatusDto]),
    __metadata("design:returntype", void 0)
], PassportController.prototype, "updatePassportStatus", null);
exports.PassportController = PassportController = __decorate([
    (0, common_1.Controller)('passport'),
    __metadata("design:paramtypes", [passport_service_1.PassportService])
], PassportController);
//# sourceMappingURL=passport.controller.js.map