"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PasaporteLogService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const pasaporte_log_entity_1 = require("./entities/pasaporte_log.entity");
let PasaporteLogService = class PasaporteLogService {
    repo;
    constructor(repo) {
        this.repo = repo;
    }
    create(createPasaporteLogDto) {
        return 'This action adds a new pasaporteLog';
    }
    async getDetallePorFechaYEstado(fecha, status, horaDesde, horaHasta, numeroLocal) {
        const query = this.repo
            .createQueryBuilder('log')
            .where('DATE(log.fecha) = :fecha', { fecha });
        if (status) {
            query.andWhere('log.status = :status', { status });
        }
        if (horaDesde) {
            query.andWhere(`log.ts >= :horaDesde`, { horaDesde });
        }
        if (horaHasta) {
            query.andWhere(`log.ts <= :horaHasta`, { horaHasta });
        }
        if (numeroLocal) {
            query.andWhere('log.numeroLocal = :numeroLocal', { numeroLocal });
        }
        return await query.orderBy('log.fecha', 'DESC').getMany();
    }
    async getResumenPorFechas(desde, hasta, status, numeroLocal) {
        const condiciones = [];
        const params = [];
        let index = 1;
        condiciones.push(`fecha >= $${index++}::date`);
        params.push(desde);
        condiciones.push(`fecha < ($${index++}::date + interval '1 day')`);
        params.push(hasta);
        if (status) {
            condiciones.push(`status = $${index++}`);
            params.push(status);
        }
        if (numeroLocal) {
            condiciones.push(`"numero_local" = $${index++}`);
            params.push(numeroLocal);
        }
        const whereClause = condiciones.length
            ? `WHERE ${condiciones.join(' AND ')}`
            : '';
        const rawData = await this.repo.query(`
      SELECT 
        DATE(fecha) as fecha,
        "numero_local" as "numeroLocal",
        SUM(CASE WHEN status = 'HABILITADO' THEN 1 ELSE 0 END) as habilitados,
        SUM(CASE WHEN status = 'BLOQUEADO' THEN 1 ELSE 0 END) as bloqueados,
        SUM(CASE WHEN status = 'DESCONOCIDO' THEN 1 ELSE 0 END) as desconocidos
      FROM passport_log
      ${whereClause}
      GROUP BY DATE(fecha), "numero_local"
      ORDER BY DATE(fecha) DESC 
      `, params);
        return rawData;
    }
    async getLocalesUnicos() {
        const resultados = await this.repo
            .createQueryBuilder('log')
            .select('DISTINCT log.numeroLocal', 'numeroLocal')
            .where('log.numeroLocal IS NOT NULL')
            .orderBy('log.numeroLocal', 'ASC')
            .getRawMany();
        return resultados.map((r) => r.numeroLocal);
    }
    async findAllExcelExport() {
        return this.repo.find({
            order: { fecha: 'DESC' },
            take: 1000,
        });
    }
    async findAllExcelExportByNumerolocal(numeroLocal) {
        return this.repo.find({
            where: { numeroLocal },
            order: { fecha: 'DESC' },
            take: 1000,
        });
    }
};
exports.PasaporteLogService = PasaporteLogService;
exports.PasaporteLogService = PasaporteLogService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(pasaporte_log_entity_1.PassportLog)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], PasaporteLogService);
//# sourceMappingURL=pasaporte_log.service.js.map