"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var MailReaderService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailReaderService = void 0;
const common_1 = require("@nestjs/common");
const axios_1 = require("axios");
const sync_1 = require("csv-parse/sync");
const FormData = require("form-data");
const imap_1 = require("imap");
const mailparser_1 = require("mailparser");
const XLSX = require("xlsx");
let MailReaderService = MailReaderService_1 = class MailReaderService {
    logger = new common_1.Logger(MailReaderService_1.name);
    async leerCorreoYSubirArchivo() {
        const imap = new imap_1.default({
            user: process.env.MAIL_USER,
            password: process.env.MAIL_PASS,
            host: process.env.MAIL_HOST,
            port: process.env.MAIL_PORT ?? 993,
            tls: true,
        });
        const openInbox = () => new Promise((resolve, reject) => {
            imap.openBox('INBOX', false, (err, box) => {
                if (err)
                    return reject(err);
                resolve();
            });
        });
        return new Promise((resolve, reject) => {
            imap.once('ready', async () => {
                try {
                    await openInbox();
                    imap.search(['UNSEEN', ['SUBJECT', 'CSV PASAPORTES']], (err, results) => {
                        if (!results || results.length === 0) {
                            this.logger.log('No hay correos nuevos.');
                            imap.end();
                            return resolve();
                        }
                        const f = imap.fetch(results.slice(-1), {
                            bodies: '',
                            struct: true,
                        });
                        f.on('message', (msg) => {
                            msg.on('body', (stream) => {
                                (0, mailparser_1.simpleParser)(stream, async (err, parsed) => {
                                    const attachment = parsed.attachments?.find((a) => a.filename?.endsWith('.csv'));
                                    if (!attachment) {
                                        this.logger.warn('No se encontró archivo CSV adjunto.');
                                        imap.end();
                                        return resolve();
                                    }
                                    const csvData = attachment.content.toString('utf-8');
                                    const records = (0, sync_1.parse)(csvData, {
                                        columns: true,
                                        skip_empty_lines: true,
                                        cast: (value) => value.trim(),
                                    });
                                    const worksheet = XLSX.utils.json_to_sheet(records);
                                    const workbook = XLSX.utils.book_new();
                                    XLSX.utils.book_append_sheet(workbook, worksheet, 'pasaportes');
                                    const buffer = XLSX.write(workbook, {
                                        type: 'buffer',
                                        bookType: 'xlsx',
                                    });
                                    const form = new FormData();
                                    form.append('file', buffer, {
                                        filename: 'pasaportes.xlsx',
                                        contentType: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
                                    });
                                    await axios_1.default.post(`${process.env.CLOUD_SELF_URL}/excel/upload/passport`, form, {
                                        headers: {
                                            Authorization: `Bearer ${process.env.SYNC_TOKEN}`,
                                            ...form.getHeaders(),
                                        },
                                    });
                                    this.logger.log('Archivo subido al endpoint correctamente.');
                                    imap.end();
                                    return resolve();
                                });
                            });
                        });
                        f.once('error', (err) => {
                            this.logger.error('Error al procesar mensaje', err);
                            imap.end();
                            return reject(err);
                        });
                    });
                }
                catch (error) {
                    this.logger.error('Error en lectura de correo', error);
                    imap.end();
                    return reject(error);
                }
            });
            imap.once('error', (err) => {
                this.logger.error('Error de conexión IMAP', err);
                return reject(err);
            });
            imap.connect();
        });
    }
};
exports.MailReaderService = MailReaderService;
exports.MailReaderService = MailReaderService = MailReaderService_1 = __decorate([
    (0, common_1.Injectable)()
], MailReaderService);
//# sourceMappingURL=mail_reader.service.js.map