"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExcelService = void 0;
const common_1 = require("@nestjs/common");
const dayjs = require("dayjs");
const pasaporte_log_service_1 = require("../pasaporte_log/pasaporte_log.service");
const passport_service_1 = require("../passport/passport.service");
const XLSX = require("xlsx");
let ExcelService = class ExcelService {
    passportsService;
    passportLogService;
    constructor(passportsService, passportLogService) {
        this.passportsService = passportsService;
        this.passportLogService = passportLogService;
    }
    generateExcel(data, headers, nombreArchivo) {
        const worksheet = XLSX.utils.json_to_sheet(data, { header: headers });
        const workbook = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(workbook, worksheet, nombreArchivo);
        return XLSX.write(workbook, { type: 'buffer', bookType: 'xlsx' });
    }
    async getDataPassportLog() {
        const passports = await this.passportLogService.findAllExcelExport();
        const mappedData = passports.map((passport) => ({
            passport: passport.passportScan,
            status: passport.status,
            fecha: dayjs(passport.fecha).format('YYYY-MM-DD HH:mm:ss'),
            numeroLocal: passport.numeroLocal ?? 'NO_DEF',
        }));
        return this.generateExcel(mappedData, ['passport', 'status', 'fecha', 'numeroLocal'], 'data_alertas');
    }
    async readExcelPassport(file) {
        try {
            const workbook = XLSX.read(file.buffer, { type: 'buffer' });
            const sheetName = workbook.SheetNames[0];
            const worksheet = workbook.Sheets[sheetName];
            const rows = XLSX.utils.sheet_to_json(worksheet, { defval: null });
            const passportDtos = rows.map((row) => ({
                name: row['nombre_socio'] || 'Sin Nombre',
                passport: row['pasaporte'],
                active: row['estado'] === 'activo' ? true : false,
            }));
            const splitIntoBatches = (array, size) => {
                const batches = [];
                for (let i = 0; i < array.length; i += size) {
                    batches.push(array.slice(i, i + size));
                }
                return batches;
            };
            const batches = splitIntoBatches(passportDtos, 100);
            for (const batch of batches) {
                await this.passportsService.createUpdateMany(batch);
            }
            return { status: 'Success', message: 'Passports processed successfully' };
        }
        catch (error) {
            throw new Error(error.message);
        }
    }
    async getDataPassportLogPorLocal(numeroLocal) {
        const passports = await this.passportLogService.findAllExcelExportByNumerolocal(numeroLocal);
        const mappedData = passports.map((passport) => ({
            passport: passport.passportScan,
            status: passport.status,
            fecha: dayjs(passport.fecha).format('YYYY-MM-DD HH:mm:ss'),
            numeroLocal: passport.numeroLocal ?? 'NO_DEF',
        }));
        return this.generateExcel(mappedData, ['passport', 'status', 'fecha', 'numeroLocal'], `data_alertas_local_${numeroLocal}`);
    }
};
exports.ExcelService = ExcelService;
exports.ExcelService = ExcelService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [passport_service_1.PassportService,
        pasaporte_log_service_1.PasaporteLogService])
], ExcelService);
//# sourceMappingURL=excel.service.js.map