"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExcelController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const excel_service_1 = require("./excel.service");
let ExcelController = class ExcelController {
    excelService;
    constructor(excelService) {
        this.excelService = excelService;
    }
    async importPassport(file) {
        if (!file) {
            throw new Error('No file uploaded');
        }
        return this.excelService.readExcelPassport(file);
    }
    async exportPassportLog(res) {
        const buffer = await this.excelService.getDataPassportLog();
        res.header('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        res.header('Content-Disposition', 'attachment; filename=data.xlsx');
        res.header('Content-Length', buffer.length.toString());
        res.send(buffer);
    }
    async exportPassportLogPorLocal(res, numeroLocal) {
        const buffer = await this.excelService.getDataPassportLogPorLocal(numeroLocal);
        res.header('Content-Type', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        res.header('Content-Disposition', `attachment; filename=data_local_${numeroLocal}.xlsx`);
        res.header('Content-Length', buffer.length.toString());
        res.send(buffer);
    }
};
exports.ExcelController = ExcelController;
__decorate([
    (0, common_1.Post)('upload/passport'),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('file')),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ExcelController.prototype, "importPassport", null);
__decorate([
    (0, common_1.Get)('download/passport_log'),
    __param(0, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], ExcelController.prototype, "exportPassportLog", null);
__decorate([
    (0, common_1.Get)('download/passport_log/:numeroLocal'),
    __param(0, (0, common_1.Res)()),
    __param(1, (0, common_1.Param)('numeroLocal')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object, String]),
    __metadata("design:returntype", Promise)
], ExcelController.prototype, "exportPassportLogPorLocal", null);
exports.ExcelController = ExcelController = __decorate([
    (0, common_1.Controller)('excel'),
    __metadata("design:paramtypes", [excel_service_1.ExcelService])
], ExcelController);
//# sourceMappingURL=excel.controller.js.map